var particles_fountainModel,
	particles_model,
	particles_sphere,
	particles_bubble

function particles_init()
{
	//	'fountain' model
	particles_fountainModel = new Model();

	var s = 99*4
	particles_fountainModel.vertices =
	[
		{x:  8,y:   32,z:  8},
		{x: -8,y:   32,z:  8},
		{x: -8,y:   32,z: -8},
		{x:  8,y:   32,z: -8},

		{x:  16,y:  0,z:  16},
		{x: -16,y:  0,z:  16},
		{x: -16,y:  0,z: -16},
		{x:  16,y:  0,z: -16},


		{x:  48,y:  0,z:  48},
		{x:  32,y:  0,z:  48},
		{x:  48,y:  0,z:  32}


	]

	for( var i=0;i<6; i++ )
	{
		particles_fountainModel.colors.push( '#'
			+('0'+Math.min(255,Math.max(0,Math.round(i*12)))).slice(-2)
			+('0'+Math.min(255,Math.max(0,Math.round(i*16)))).slice(-2)
			+('0'+Math.min(255,Math.max(0,Math.round(i*24)))).slice(-2)
		)
	}


	particles_fountainModel.faces =
	[
		{color:5,	a: 3,b: 2,c: 1,d: 0},

		{color:4,	a: 1,b: 5,c: 4,d: 0},
		{color:3,	a: 3,b: 7,c: 6,d: 2},
		{color:2,	a: 0,b: 4,c: 7,d: 3},
		{color:2,	a: 2,b: 6,c: 5,d: 1},

		{color:0,	a: 4,b: 5,c: 9,d: 8},
		{color:0,	a: 7,b: 4,c: 8,d: 10}

	]


	//	a bunch of particles
	particles_model = new Model();
	for( var i=0; i<256; i++ )
	{
		particles_model.vertices.push
		(
			{
				x:0,
				y:0,
				z:0,
				cx:Math.cos( i )*(2+2*Math.random()),
				cy:Math.sin( i )*(2+2*Math.random())
			}
		)
	}







	//	sphere
	var tmpCanvas			= document.createElement('canvas'),
		tmpCanvasContext	= tmpCanvas.getContext('2d');

	tmpCanvas.width = tmpCanvas.height = 64;

	var	grad = tmpCanvasContext.createRadialGradient( 32+12,32-12,0,32,32,32 );
	grad.addColorStop(  0,		'#fff' );
	grad.addColorStop( .2,		'#fff' );
	grad.addColorStop( .6,		'#666' );
	grad.addColorStop( .9,	'#333' );
	grad.addColorStop( 1,		'rgba(51,51,51,0)' );
	tmpCanvasContext.fillStyle = grad;
	tmpCanvasContext.fillRect( 0,0,64,64 );

	particles_sphere = tmpCanvas ;


	//	bubble
	var tmpCanvas			= document.createElement('canvas'),
		tmpCanvasContext	= tmpCanvas.getContext('2d');

	tmpCanvas.width = tmpCanvas.height = 64;

	var	grad = tmpCanvasContext.createRadialGradient( 32+12,32-12,0,32,32,32 );
	grad.addColorStop( 0,		'rgba(255,255,255,1)' );
	grad.addColorStop( .2,		'rgba(255,255,255,0)' );
	grad.addColorStop( .6,		'rgba(0,0,51,0)' );
	grad.addColorStop( .9,		'rgba(153,255,255,.33)' );
	grad.addColorStop( 1,		'rgba(0,255,255,0)' );

	tmpCanvasContext.fillStyle = grad;
	tmpCanvasContext.fillRect( 0,0,64,64 );

	particles_bubble = tmpCanvas ;



	progressBarIndex++;
}



function particles_fountain( a, t, i )
{
	var out={},
		d = i*2.1+t*12

	while( d>32 )
		d-=32;

	out.x = d*a.cx
	out.y = (32-d)+Math.abs( 2*(32-d)*Math.sin( d/32*Math.PI*3 ) )
	out.z = d*a.cy
	return out
}


function particles_render( currentTime, percentage, extraArguments )
{
	//	background
//	offScreenCanvasContext.drawImage( backgrounds_red[ 4+(Math.floor(percentage*8)&3)], 0,0 )

	offScreenCanvasContext.fillStyle = particles_fountainModel.colors[1]
	offScreenCanvasContext.fillRect( 0,0,320,160 )


	var	camera		= {x:-32*Math.cos(percentage*Math.PI),y:32-8*Math.cos(percentage*Math.PI),z:-64*2-64*Math.cos(percentage*Math.PI)*0},
		angles		= {x:-Math.abs(Math.PI/8*Math.cos(percentage*Math.PI/2)),y:-percentage*Math.PI,z:percentage*Math.PI*0},
		fovAngle	= Math.PI/4




	//	fountain
	particles_fountainModel.rotateAndProject(
		angles,
		camera,
		160, 80, fovAngle
	)

	if( percentage<.1 )
		renderAreaHandle.style.top = (50+(2-2000*(percentage*percentage*percentage))*Math.cos( percentage*Math.PI*32 ))+'%'
	else if( renderAreaHandle.style.top!='50%' )
			renderAreaHandle.style.top='50%'


	particles_fountainModel.sortFaces();
	particles_fountainModel.drawTriangles( offScreenCanvasContext );


	//	particles
	particles_model.rotateAndProject(
		angles,
		camera,
		160, 80, fovAngle,
		particles_fountain,
		percentage*Math.PI
	)

	var tmpVertices = particles_model.vertices;
//	tmpVertices.sort( function(a,b){return b.zr-a.zr} )
	for( var i=0,currentVertex; currentVertex=tmpVertices[i]; i++ )
	{
		var size = Math.max( 1, Math.min( 64, 768/currentVertex.zr ) )
		offScreenCanvasContext.drawImage( particles_bubble, 0,0,64,64, currentVertex.xs-.5*size, currentVertex.ys-.5*size, size,size )
	}
}

